# Prof-TC
# Mai 2121
# Caractéristique d'une photorésistance
# Tracé de U=f(I) pour une photorésistance

#Affichage du nom du programme
print("_________________________________________________________")
print("Caractéristique d'une photorésistance")
print("_________________________________________________________")

#Importation des bibliothèques
import matplotlib.pyplot as plt
import numpy as np

#Valeurs expérimentales à modifier selon l'expérience (U en volt et I en milliampère)
print("**********************************************")
ImA=[0, 2.20, 2.22, 2.24, 2.31, 2.35, 2.40, 2.47, 2.51, 2.53, 2.58, 2.60, 2.64, 2.67, 2.71, 2.73, 2.78, 2.82, 2.84, 2.89, 2.91, 2.95, 3.04, 3.15, 3.20, 3.34, 3.44, 3.51, 3.64, 3.82]
U = [0, 2.38, 2.38, 2.42, 2.47, 2.54, 2.58, 2.64, 2.69, 2.72, 2.79, 2.83, 2.85, 2.89, 2.93, 2.96, 3.03, 3.05, 3.08, 3.12, 3.16, 3.20, 3.29, 3.52, 3.48, 3.67, 3.77, 3.83, 4.00, 4.16]
print("**********************************************")

# Nombre de points expérimentaux
K=len(ImA)

# Détermination des valeurs de I en ampère
I=[]
for i in range(K):
    I.append(round(ImA[i]/1000,6))

#Affichage des valeurs expérimentales et du nombre de points
print("valeurs de I:, ",I)
print("valeurs de U: ",U)
print("Il y a ",K," couples de points")
print("**********************************************")

#Initialisation des variables
Imoy=0.0
Umoy=0.0
N=0.0
D=0.0
a=0.0
b=0.0
Imin=I[0]
Umin=U[0]
Imax=I[len(I)-1]
Umax=U[len(U)-1]

# Initialisation de la figure
fig, ax = plt.subplots()

#Calcul des coefficients de la droite représentant U=f(I)
for i in range (len(I)):
    Imoy=Imoy+I[i]
    Umoy=Umoy+U[i]

Imoy=Imoy/(len(I))
Umoy=Umoy/(len(U))

for i in range (len(I)):
    N=N+(I[i]-Imoy)*(U[i]-Umoy)
    D=D+(I[i]-Imoy)*(I[i]-Imoy)

a=N/D #Coefficient directeur de la droite
R=a #Valeur de la résistance
b=Umoy-a*Imoy #Ordonnée à l'origine de la droite

#Mise en écriture avec 5 décimales pour l'affichage de l'équation
Rs=round(R,5)
bs=round (b,5)

#Mise en écriture pour l'affichage de la résistance
Rp=int(R+0.5)

#Tracé des axes, labels et titre du graphique
plt.axis([0, Imax, 0, Umax])
plt.xlabel('I (A)',color='green', fontsize=20)
plt.ylabel('U (V)',color='green', fontsize=20)
plt.title("Caractéristique d'une photorésistance", color='red', fontsize=10)
plt.grid()

#Tracé des valeurs expérimentales
plt.scatter(I,U,marker='o',color='r',linewidth = 4)

#Tracé de la droite
x=np.linspace(0,Imax+1,200)
y=R*x+b
plt.plot(x,y,linewidth = 2)

#Ecriture de l'équation de la droite
plt.text((Imax)/2, Umax-Umax*0.1, "U = "+str(Rs)+" x I + "+str(bs), color='green', fontsize=12,horizontalalignment = 'center')

#Ecriture de la valeur de la résistance
plt.text((Imax)/2, Umax-Umax*0.2, "R = "+str(Rp)+" Ohm", color='green', fontsize=12,horizontalalignment = 'center')

#Affichage du graphique
plt.show()

# Sauvegarde de la figure dans le dossier où se trouve le programme
fig.savefig("Caractéristique d'une photorésistance")

print("********************************************************")
print("L'équation de la droite est: U = ",Rs," x I + ",bs)
print("********************************************************")

#Fin du programme